/**
  ******************************************************************************
  * @file    main.c 
  * @author  Ruediger R. Asche
  * @version V1.0.0
  * @date    July 14, 2016
  * @brief   Program entry point
  ******************************************************************************
  * @attention
  *
  * THE PRESENT FIRMWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
  * WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE
  * TIME. AS A RESULT, THE AUTHOR SHALL NOT BE HELD LIABLE FOR ANY
  * DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING
  * FROM THE CONTENT OF SUCH FIRMWARE AND/OR THE USE MADE BY CUSTOMERS OF THE
  * CODING INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
  ******************************************************************************  
  */ 

/* Includes ------------------------------------------------------------------*/
#include "stm32f4_discovery.h"
#include "freertos.h"
#include "task.h"

#define LED_ORANGE LED3
#define LED_GREEN  LED4
#define LED_BLUE   LED6
#define LED_RED    LED5

#define BLINKEDELAYINMS 1000
#define BLINKTASKPRIORITY (configMAX_PRIORITIES-2)

/* Private functions ---------------------------------------------------------*/

/** @brief FreeRTOS task function
 *
 *  @param p_Dum FreeRTOS Task Parameter. Unused.
 *  @return none. Function does not return.
 */


void BlinkTest(void *p_Dum)
{
  while (1)
  {
    STM_EVAL_LEDToggle(LED_ORANGE);
    STM_EVAL_LEDToggle(LED_BLUE);

    vTaskDelay(BLINKEDELAYINMS);

    STM_EVAL_LEDToggle(LED_GREEN);
    STM_EVAL_LEDToggle(LED_RED);

    vTaskDelay(BLINKEDELAYINMS);
  }  
}

/** @brief Application entry point
 *
 *
 *  @return Dummy (required by unused C Runtime Code). Function does not return unless vTaskStartScheduler() has a problem.
 */

int main(void)
{  
  /* Initialize Leds mounted on STM32F4-Discovery board */
  STM_EVAL_LEDInit(LED_GREEN);
  STM_EVAL_LEDInit(LED_ORANGE);
  STM_EVAL_LEDInit(LED_RED);
  STM_EVAL_LEDInit(LED_BLUE);

	xTaskCreate(BlinkTest, "BlinkTask", configMINIMAL_STACK_SIZE,
			0, BLINKTASKPRIORITY, (TaskHandle_t *) 0);

  /* Start the scheduler */
	vTaskStartScheduler();
}
